function [ Z,X,Y ] = TriangleNormal( p,q,r )
%[ Z,X,Y ] = TriangleNormal( p,q,r )
%   Compute the unit vector normal to a triangle with vertices (p,q,r)
%   Z = unit vector normal to plane of triangle
%   X = unit vector direction from p to q
%   Y = unit vector = Cross(Z,X)
%
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

    X = vct3(q.el-p.el).unit;
    Z = vct3(cross(X.el,r.el-p.el)).unit();
    Y = cross(Z,X);  
end

